#ifndef _PBOX_H_
#define _PBOX_H_

#define PB_NULL     0
#define PB_INT	    1
#define PB_STRING   2

typedef  struct PB_OBJECT {
	void *data;
	int type;
	int size;
	struct PB_OBJECT *next;
} PB_OBJECT;

typedef struct PACKET_BOX {
	PB_OBJECT *objects;
	unsigned char *data;
	int size;
	char cmd[5];
} PACKET_BOX;

PACKET_BOX *packet_box_create(const char *cmd);
void packet_box_add_int(PACKET_BOX *pb, int i, int bits);
void packet_box_add_string(PACKET_BOX *pb, char *string);
int packet_box_get_int(PACKET_BOX *pb);
int packet_box_get_string(PACKET_BOX *pb, char *string, int len);
void packet_box_serialize(PACKET_BOX *pb);
PACKET_BOX *packet_box_unserialize(unsigned char *data, int size);
void packet_box_destroy(PACKET_BOX *pb);

#endif
